<!doctype html>

<html lang="en">

<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1, viewport-fit=cover">
<title><?= !empty($title) ? $title . ' - ' . site_config("site_title", "author") : site_config("site_title", "author") ?></title>
<meta name="description" content="<?= site_config('site_description', 'Site desc') ?>">
<link href="https://fonts.googleapis.com/css2?family=Plus+Jakarta+Sans:wght@400;500;600;800&display=swap" rel="stylesheet">
<style>
:root {
--bg-color: #ffffff;
--text-main: #1a1f2e;
--text-secondary: #64748b;
--accent-soft: #6366f1;
--accent-bg: #f5f7ff;
--card-shadow: 0 20px 50px rgba(0, 0, 0, 0.05);
--border-color: #f1f5f9;
}

code
Code
download
content_copy
expand_less
* {
        box-sizing: border-box;
        margin: 0;
        padding: 0;
    }

    body {
        font-family: 'Plus Jakarta Sans', sans-serif;
        background-color: var(--bg-color);
        color: var(--text-main);
        height: 100vh;
        display: flex;
        align-items: center;
        justify-content: center;
        -webkit-font-smoothing: antialiased;
    }

    .wrapper {
        width: 100%;
        max-width: 600px;
        padding: 40px;
        text-align: center;
    }

    .visual-container {
        position: relative;
        margin-bottom: 40px;
    }

    .error-code {
        font-size: 160px;
        font-weight: 800;
        line-height: 1;
        color: var(--text-main);
        letter-spacing: -8px;
        opacity: 0.05;
        position: absolute;
        top: 50%;
        left: 50%;
        transform: translate(-50%, -50%);
        z-index: 0;
    }

    .illustration {
        position: relative;
        z-index: 1;
        font-size: 80px;
        filter: drop-shadow(0 10px 20px rgba(99, 102, 241, 0.2));
    }

    .content h1 {
        font-size: 32px;
        font-weight: 800;
        margin-bottom: 16px;
        letter-spacing: -0.5px;
    }

    .content p {
        font-size: 18px;
        color: var(--text-secondary);
        line-height: 1.6;
        margin-bottom: 32px;
        font-weight: 400;
    }

    .button-group {
        display: flex;
        gap: 12px;
        justify-content: center;
        margin-bottom: 48px;
    }

    .btn {
        padding: 14px 28px;
        border-radius: 14px;
        text-decoration: none;
        font-weight: 600;
        font-size: 15px;
        transition: all 0.2s ease;
    }

    .btn-primary {
        background-color: var(--text-main);
        color: #ffffff;
        box-shadow: 0 10px 20px rgba(26, 31, 46, 0.15);
    }

    .btn-primary:hover {
        transform: translateY(-2px);
        background-color: #2d3548;
    }

    .btn-soft {
        background-color: var(--accent-bg);
        color: var(--accent-soft);
    }

    .btn-soft:hover {
        background-color: #ebedff;
        transform: translateY(-2px);
    }

    .footer {
        border-top: 1px solid var(--border-color);
        padding-top: 24px;
        display: flex;
        justify-content: space-between;
        align-items: center;
        font-size: 13px;
        color: var(--text-secondary);
    }

    .footer a {
        color: var(--text-main);
        text-decoration: none;
        font-weight: 600;
    }

    .status-dot {
        display: inline-block;
        width: 8px;
        height: 8px;
        background: #10b981;
        border-radius: 50%;
        margin-right: 6px;
        animation: pulse 2s infinite;
    }

    @keyframes pulse {
        0% { opacity: 1; transform: scale(1); }
        50% { opacity: 0.5; transform: scale(1.2); }
        100% { opacity: 1; transform: scale(1); }
    }

    @media (max-width: 480px) {
        .wrapper { padding: 24px; }
        .button-group { flex-direction: column; }
        .btn { width: 100%; }
        .footer { flex-direction: column; gap: 12px; }
    }
</style>
</head>

<body>
<main class="wrapper">
<div class="visual-container">
<div class="error-code">404</div>
<div class="illustration">🔍</div>
</div>

code
Code
download
content_copy
expand_less
<section class="content">
        <h1>Page not found</h1>
        <p>The page you are looking for might have been removed, had its name changed or is temporarily unavailable.</p>

        <div class="button-group">
            <a href="<?= base_url() ?>" class="btn btn-primary">Back to home</a>
            <a href="<?= base_url('contact') ?>" class="btn btn-soft">Contact support</a>
        </div>
    </section>

    <footer class="footer">
        <div>
            <span class="status-dot"></span>
            Systems are functional
        </div>
        <div>
            © <?= date('Y') ?> <a href="<?= base_url() ?>"><?= site_config("site_name", "Platform") ?></a>
        </div>
    </footer>
</main>
</body>

</html>
